/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lib.toma.animations.api.lifecycle.IRegistrationListener;
import lib.toma.animations.api.lifecycle.IRegistry;
import lib.toma.animations.api.lifecycle.IRegistryEntry;
import net.minecraft.util.ResourceLocation;

public class Registry<T extends IRegistryEntry>
implements IRegistry<T> {
    private final Map<ResourceLocation, T> elementMap;
    private final List<IRegistrationListener<T>> registryListeners = new ArrayList<IRegistrationListener<T>>();

    private Registry(RegistryBuilder<T> builder) {
        this.elementMap = ((RegistryBuilder)builder).defaultMap;
        if (((RegistryBuilder)builder).vanillaListener != null) {
            this.addCallback(((RegistryBuilder)builder).vanillaListener);
        }
    }

    @Override
    public T getElement(ResourceLocation key) {
        return (T)((IRegistryEntry)this.elementMap.get(key));
    }

    @Override
    public void addCallback(IRegistrationListener<T> listener) {
        this.registryListeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public Collection<ResourceLocation> keys() {
        return this.elementMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.elementMap.values();
    }

    public void load(boolean isDevMode) {
        this.registryListeners.forEach(listener -> this.register((IRegistrationListener<T>)listener, isDevMode));
    }

    private void register(IRegistrationListener<T> listener, boolean isDevMode) {
        for (IRegistryEntry t : listener.getAll(isDevMode)) {
            this.register(t);
        }
    }

    private void register(T t) {
        ResourceLocation key = t.getKey();
        if (this.elementMap.put(key, t) != null) {
            throw new UnsupportedOperationException("Duplicate registry element: " + key);
        }
    }

    public static class RegistryBuilder<T extends IRegistryEntry> {
        private Map<ResourceLocation, T> defaultMap = new HashMap<ResourceLocation, T>();
        private IRegistrationListener<T> vanillaListener;

        public RegistryBuilder<T> map(Map<ResourceLocation, T> elementMap) {
            this.defaultMap = elementMap;
            return this;
        }

        public RegistryBuilder<T> vanillaListener(IRegistrationListener<T> listener) {
            this.vanillaListener = listener;
            return this;
        }

        public IRegistry<T> buildRegistry() {
            return new Registry(this);
        }
    }
}

